/*
 * AntennaEntryDisplay.cpp
 *
 *  Created on: 16.12.2011
 *      Author: stefan.detter
 */

#include "AntennaEntry.h"

#include <QLinearGradient>
#include <QColor>

TreeItem::TYPE AntennaEntry::itemType() const
{
	return ANTENNA;
}

QVariant AntennaEntry::data(int column, int role) const
{
	switch(role)
	{
		case Qt::TextAlignmentRole:
		{
			return int(Qt::AlignLeft | Qt::AlignVCenter);
			break;
		}

		case Qt::DisplayRole:
		{
			switch((TreeItem::COLUMN_INDEX)column)
			{
            case COL_ID:
                return tr("Antenna #") + QString("%1").arg(m_antennaId, 2);
            case COL_Action:
                if(m_receivedRfp)
                    return tr("Reflection:");
                break;
            case COL_State:
                if(m_receivedRfp)
                    return QString::asprintf("%+4.2f", m_currentRfp) + tr(" dBm");
                break;
            default:
                break;
			}
			break;
		}

		case Qt::DecorationRole:
		{
			switch((TreeItem::COLUMN_INDEX)column)
			{
			case COL_ID:
                return QPixmap(":/icons/antenna_icon");
			default:
				break;
			}
			break;
		}

		case Qt::FontRole:
		{
			QFont f = m_treeBoxFont;
			f.setBold(true);
			switch((TreeItem::COLUMN_INDEX)column)
			{
			case COL_ID:
#ifdef Q_OS_WIN
				f.setPointSize(10);
#else
				f.setPointSize(12);
#endif
				break;
            default:
                break;
            }

			return f;
			break;
		}

		case Qt::BackgroundRole:
		{
            if(m_active && m_hasRfpError){
                QLinearGradient lg(0, 0, 0, 50 );
                lg.setColorAt(0, Qt::red);
                lg.setColorAt(1, Qt::white);
                return QBrush(lg);
            }
            else if(m_hasRfpError){
                QLinearGradient lg(0, 0, 0, 50 );
                lg.setColorAt(0, QColor(Qt::darkRed).lighter());
                lg.setColorAt(1, Qt::white);
                return QBrush(lg);
            }
            else if(m_active){
                QLinearGradient lg(0, 0, 0, 50 );
                lg.setColorAt(0, Qt::green);
                lg.setColorAt(1, Qt::white);
                return QBrush(lg);
            }
            else {
                QLinearGradient lg(0, 0, 0, 45 );
                lg.setColorAt(0, QColor(0x96, 0x99, 0xA2));
                lg.setColorAt(1, Qt::white);
                return QBrush(lg);
            }
			break;
		}

		case Qt::ForegroundRole:
		{
			QColor c(Qt::black);
			return QBrush(c);
			break;
		}
	}

	return QVariant();
}

int AntennaEntry::informationRowCount () const
{
	return m_parent->informationRowCount();
}

QVariant AntennaEntry::information (int row, int column, int role) const
{
	return m_parent->information(row, column, role);
}

QList<int> AntennaEntry::informationSpan() const
{
	return m_parent->informationSpan();
}


